/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GAction                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "TString.h"

#include "Gfitter/GAction.h"
#include "Gfitter/GStringList.h"

Gfitter::GAction::GAction( const TString& name, const TString& args )
   : m_active( kFALSE ),
     m_name  ( name )
{
   // parse string
   GStringList vlist( args );

   // check if active
   if      (vlist[0] == "T" || vlist[0] == "t") m_active = kTRUE;
   else if (vlist[0] == "F" || vlist[0] == "f") m_active = kFALSE;
   else {
      m_logger << kFATAL 
               << "Wrong format in Action: \"" << m_name 
               << "\" missing boolean in first field; args: \"" << args << "\"" << GEndl;
   }

   // clear lists
   m_args.clear();
   m_pars.clear();

   // loop over all actions
   for (Int_t iarg=1; iarg<vlist.GetEntries(); iarg++) {
      // check if contains "=" -> is a parameter
      if (vlist[iarg].Contains("=")) m_pars.push_back( vlist[iarg] );
      else                           m_args.push_back( vlist[iarg] );         
   }
}
