/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GAction                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Action field                                                              *
 *      Required format: action1:action2:...:par1=1,par2=4                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GAction
#define Gfitter_GAction

#include <vector>

#include "Gfitter/GObject.h"

class TString;

namespace Gfitter {

   class GAction : public GObject {

   public:

      GAction( const TString& name, const TString& args );
      ~GAction() {}

      const TString& GetActionName() const { return m_name; }
      Bool_t         IsActive()      const { return m_active; }

      const std::vector<TString>& GetArgs() const { return m_args; }
      const std::vector<TString>& GetPars() const { return m_pars; }

   private:
            
      Bool_t               m_active;       // is action active
      TString              m_name;         // name of action
      std::vector<TString> m_args;         // arguments of action
      std::vector<TString> m_pars;         // parameters of action

   };
}

#endif
