/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GContour                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Determines fit contours                                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GContour
#define Gfitter_GContour

#include <vector>

#include "Gfitter/GObject.h"

namespace Gfitter {

   class GParameter;
   class GStore;
   class GFitterBase;

   class GContour : public GObject {

   public:

      GContour();
      ~GContour();

      void Contour2D( const TString& par1, const TString& par2, const std::vector<TString>& options );
      void Contour2D( GParameter* gpar1,   GParameter* gpar2,   const std::vector<TString>& options );
    
   private:

   };
}

#endif
