/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GCorrGaussGen                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Correlated generation of Gaussian random numbers                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GCorrGaussGen
#define Gfitter_GCorrGaussGen

#include "TMatrixD.h"

#include "Gfitter/GObject.h"

class TArrayD;

namespace Gfitter {

   class MsgLogger;

   class GCorrGaussGen : public GObject {

   public:

      GCorrGaussGen( const TMatrixD* covMat );
      GCorrGaussGen( const TMatrixD& covMat );
      GCorrGaussGen( const GCorrGaussGen& other );
      GCorrGaussGen();

      virtual ~GCorrGaussGen();

      // generates vector of Gaussian distributed and correlated random numbers
      // according to input covariance matrix, and with mean zero
      void GetGaussRnd( TArrayD &vec ) const;

      const TMatrixD& GetSqrtMatrix() const { return *m_sqrMat;}
      
      GCorrGaussGen& operator=(const GCorrGaussGen& other);

   private:

      void Initialize( const TMatrixD& covMat );

      Int_t     m_size;      // dimension (=rank) of covariance matrix
      TMatrixD *m_sqrMat;    // square root of the covariance matrix

      ClassDef(GCorrGaussGen,0)  
   };
}

#endif
