/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultContainer                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      Contains all GResults (persistent container for use in ROOT macros)       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultContainer
#define Gfitter_GResultContainer

#include <vector>

#include "TObjArray.h"
#include "TString.h"

#include "Gfitter/GObject.h"
#include "Gfitter/GResultBase.h"
#include "Gfitter/GParameter.h"

namespace Gfitter {

   class GResultContainer : public GObject {
      
   public:
      
      GResultContainer();
      virtual ~GResultContainer();
      
      void       AddResult   ( GResultBase* result ) { if (result) m_resultArray   ->Add( result ); }      
      void       AddParameter( GParameter*  par    ) { if (par)    m_parameterArray->Add( par ); }      

      // accessors
      Int_t      GetNumResults()    const { return m_resultArray   ->GetEntries(); }
      Int_t      GetNumParameters() const { return m_parameterArray->GetEntries(); }
      TObjArray& GetResults()       const { return *m_resultArray; }
      TObjArray& GetParameters()    const { return *m_parameterArray; }

      // helpers
      const GParameter* FindParameter( const TString& parName ) const;
      
   protected:
      
      TObjArray* m_resultArray;
      TObjArray* m_parameterArray;
      
      ClassDef(GResultContainer,1)
   };
}

#endif
