/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultScan1d                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Results of a Scan1d                                                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultScan1d
#define Gfitter_GResultScan1d

#include "TROOT.h"

#include "Gfitter/GResultBase.h"

class TH1F;
class TF1;
class TGraph;

namespace Gfitter {

   class GResultScan1d : public GResultBase {

   public:

      GResultScan1d();
      GResultScan1d( TH1F* hChi2 );
      ~GResultScan1d();

      // accessors

      Double_t GetValue() const;
      Double_t GetChi2Min() const;
      Double_t GetErrGaussSym ( UInt_t nsigma ) const;
      Double_t GetErrGaussAsym( Int_t  nsigma ) const;
      Double_t GetGlobCorr() const; 

      TGraph* GetGraph() {return m_graph;}

   public:

      // interface for root finder 
      static Double_t IGetGraphValForRoot( Double_t x );  

      // interface for TF1 
      static Double_t IGetGraphValForFunction( Double_t *x, Double_t *par );
		
   private:
      
      TH1F*        m_hist;  //! the input histogram
      TGraph*      m_graph; //! the derived TGraph      
      TF1*         m_func;  //! the derived TF1
    
      // wrapper around the root finder
      Double_t GetXValue( Double_t chi2, Double_t low, Double_t high ) const; 

      // this carrier
      static GResultScan1d* m_thisPointer; 

      // static pointer to this object
      static GResultScan1d* GetThisPointer() { return m_thisPointer; }        

      ClassDef(GResultScan1d,1)
   };
}

#endif
