/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterBase                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include <iomanip>
#include <ios>

#include "Gfitter/GResultWriterBase.h"
#include "Gfitter/GResultBase.h"

using namespace std;

Gfitter::GResultWriterBase::GResultWriterBase( TString resultFileName )
   : m_resultFileName( resultFileName )
{
   // open the result file
   m_resultFile.open( resultFileName, ios::out);
   InitClassName( "GResultWriterBase" );
}

Gfitter::GResultWriterBase::~GResultWriterBase()
{}

ostream& Gfitter::operator << ( ostream& os, const Gfitter::GResultWriterBase& rWriter ) 
{
   os << rWriter.GetResultFileName();
   return os;
}
