/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultWriterScreen                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include <iomanip>
#include <ios>

#include "Gfitter/GResultWriterScreen.h"
#include "Gfitter/GResultBase.h"
#include "Gfitter/GParameter.h"

Gfitter::GResultWriterScreen::GResultWriterScreen()
   : GResultWriterBase( "" )
{
   // open the result file
   InitClassName( "GResultWriter" );
}

Gfitter::GResultWriterScreen::~GResultWriterScreen()
{}

Bool_t Gfitter::GResultWriterScreen::Initialise()
{
   return kTRUE;
}

Bool_t Gfitter::GResultWriterScreen::AddResults( const TString& action )
{
   using namespace std;

   if (action=="Scan1D" || action=="Evaluate" || action=="EvaluateToy") {
      
      // get maximum variable length for beautiful output
      Int_t   maxLO = 8;
      Int_t   maxL  = maxLO;
      Int_t   length = 79 + maxL - maxLO;
      TString line; for (Int_t i=0; i<length; i++) line += "-";
   
      GParameter* parWithResult = 0;
      const GParPtrVec_t& fp = gStore()->GetParameters();	
      GParPtrVec_t fitPars;
      for (GParPtrVec_t::const_iterator par = fp.begin(); par != fp.end(); par++) {

         // print the result for those parameters which have a result
         if ((*par)->GetResult()) {
            parWithResult = *par;
            fitPars.push_back( parWithResult );
            if (TString((*par)->GetParName()).Length() > maxL) maxL = TString((*par)->GetParName()).Length();
         }
      }
   
      if (!parWithResult) m_logger << kFATAL << "No parameter with result found! " << GEndl;

      m_logger << GEndl;
      m_logger << kINFO << "Fit has converged. Elapsed time: " 
               << parWithResult->GetResult()->GetFitDuration() << GEndl;
      m_logger << kINFO << "Fit Results. Value of estimator after convergence: " 
               << parWithResult->GetResult()->GetChi2Min() << "" << GEndl;
      m_logger << kINFO << line << GEndl;
      
      m_logger << kINFO << setw(maxL) << "Variable";
      m_logger << kINFO << " |        Value | Parab error |  Upper error |  Lower error | Glob corr" 
               << GEndl;      
      m_logger << kINFO << line << GEndl;
      
      for (GParPtrVec_t::const_iterator par = fp.begin(); par != fp.end(); par++) {
         
         // print the result for those parameters which have a result
         if ((*par)->GetResult()) {
            m_logger << kINFO
                     << setw(maxL) << (*par)->GetParName() << " | "
                     << scientific << setprecision(5) << showpos 
                     << (*par)->GetResult()->GetValue()  << " | " << noshowpos 
                     << (*par)->GetResult()->GetErrGaussSym(1) << " | " << showpos 
                     << (*par)->GetResult()->GetErrGaussAsym(1) << " | " << showpos 
                     << (*par)->GetResult()->GetErrGaussAsym(-1) << " | " << noshowpos 
                     << fixed << setprecision(3)
                     << (*par)->GetResult()->GetGlobCorr() 
                     << GEndl;
         }      
      }
      m_logger << kINFO << line << GEndl;
      m_logger << GEndl;
      const TMatrixD* corrMat = parWithResult->GetResult()->GetCorrMat();
      if (corrMat != 0) {
         if (fitPars.size() > 1) m_logger << kINFO << "Correlation matrix: " << GEndl;
         GUtils::FormattedOutput( *corrMat, fitPars, m_logger, "%.3f", kFALSE );               
         m_logger << GEndl;
      }
   } 
   else {
      m_logger << kINFO << "no GResults implemented for action: " << action << GEndl;
   }

   return kTRUE;
}   

Bool_t Gfitter::GResultWriterScreen::Finalise()
{
   return kTRUE;   
}

