/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRootFinder                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      RootFinder taken from TMVA implementation                                 *
 *                                                                                *
*      Adapted from TMVA:RootFinder. Original authors:                           *
 *                                                                                *
 *      Andreas Hoecker <Andreas.Hocker@cern.ch> - CERN, Switzerland              *
 *      Helge Voss      <Helge.Voss@cern.ch>     - MPI-K Heidelberg, Germany      *
 *      Kai Voss        <Kai.Voss@cern.ch>       - U. of Victoria, Canada         *
 *                                                                                *
 * Copyright (c) 2005:                                                            *
 *      CERN, Switzerland                                                         *
 *      U. of Victoria, Canada                                                    *
 *      MPI-K Heidelberg, Germany                                                 *
 *                                                                                *
 *     http://root.cern.ch/root/html/src/TMVA__RootFinder.h.html                  *
 *                                                                                *
 * (http://tmva.sourceforge.net/LICENSE)                                          *
 **********************************************************************************/

#ifndef Gfitter_GRootFinder
#define Gfitter_GRootFinder

#include "GObject.h"

namespace Gfitter {
   
   class GRootFinder : public GObject {

   public:

      GRootFinder( Double_t (*rootVal)( Double_t ),
                  Double_t rootMin, Double_t rootMax,
                  Int_t    maxIterations = 100, 
                  Double_t absTolerance  = 0.0 );
      virtual ~GRootFinder( void );
      
      // returns the root of the function
      Double_t Root( Double_t refValue );

   private:

      Double_t m_RootMin;  // minimum root value
      Double_t m_RootMax;  // maximum root value
      Int_t    m_MaxIter;  // maximum number of iterations
      Double_t m_AbsTol;   // absolute tolerance deviation

      // function pointer
      Double_t (*m_GetRootVal)( Double_t );

   };

}

#endif

