/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GRungeKutta                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "Riostream.h"
#include "TMath.h"
#include "TString.h"

#include "Gfitter/GRungeKutta.h"

Gfitter::GRungeKutta::GRungeKutta( Double_t (*rungeVal)( Double_t, Double_t ), 
                                   Int_t maxIterations )
  : m_MaxIter( maxIterations )
{
   // constructor
   m_GetRungeVal = rungeVal;
   InitClassName( "GRungeKutta" );
}

Gfitter::GRungeKutta::~GRungeKutta( void )
{
  // destructor
}

// fouth order Runge-Kutta formulae 
// (see for instance http://mathworld.wolfram.com/Runge-KuttaMethod.html)
Double_t Gfitter::GRungeKutta::GetYEndValue( Double_t xStart, Double_t yStart , Double_t xEnd)
{
   Double_t k1=0, k2=0, k3=0, k4=0;
   Double_t x = xStart;
   Double_t y = yStart;
   Double_t step = (xEnd - xStart)/(1.0*m_MaxIter);
   for ( Int_t i=0; i < m_MaxIter; i++ ){
      k1 = step*(*m_GetRungeVal)( x, y );
      k2 = step*(*m_GetRungeVal)( x + 0.5*step, y + 0.5*k1);
      k3 = step*(*m_GetRungeVal)( x + 0.5*step, y + 0.5*k2);
      k4 = step*(*m_GetRungeVal)( x + step, y + k3 );
      x  = x + step; 
      y  = y + 1/6.0*k1 + 1/3.0*k2 + 1/3.0*k3 + 1/6.0*k4;
   }

   return y;
}
