/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GScalerFormula                                                        *
 *                                                                                *
 * Description:                                                                   *
 *      Formula parameter scaler                                                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GScalerFormula
#define Gfitter_GScalerFormula

#include "GScalerBase.h"

class TString;
class TFormula;

namespace Gfitter {

   class GParameter;
   class GData;

   class GScalerFormula : public GScalerBase {

   public:

      GScalerFormula( const TString& expression, Double_t errp, Double_t errm, Int_t sign = +1 );
      GScalerFormula( const GScalerFormula& );  
      virtual ~GScalerFormula();

      // rescaled central value
      Double_t GetBias();

      // accessors
      void     SetParameter( const GParameter* par );

   private:

      // use of formulas
      TFormula* m_formula;    // the formula describing the expression
   };
}

#endif
