/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GScalerLinear                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>

#include "TString.h"
#include "TMath.h"

#include "Gfitter/GScalerLinear.h"
#include "Gfitter/GParameter.h"
#include "Gfitter/GData.h"
#include "Gfitter/GTheory.h"

using namespace std;

Gfitter::GScalerLinear::GScalerLinear( const TString& parName, Double_t errp, Double_t errm, Int_t sign )
   : GScalerBase( parName, errp, errm, sign )
{
   m_logger.SetSource( "GScalerLinear" );
}

Gfitter::GScalerLinear::GScalerLinear( const GScalerLinear& other )
   : GScalerBase( other )
{}

Gfitter::GScalerLinear::~GScalerLinear()
{}
 
Double_t Gfitter::GScalerLinear::GetBias() 
{
   // first call of bias function -> compute fixed offset
   if (m_first) {

      if (!SanityCheck( m_refData )) m_logger << kFATAL << "Sanity check failed" << GEndl;
      
      // ----- compute fixed offset 
      
      // reference value for constant offset
      m_ref    = m_refData->GetValue();
      m_denomP = TMath::Abs(m_refData->GetErrGaussp());
      m_denomM = TMath::Abs(m_refData->GetErrGaussm());
   }
   
   // ----- compute current deviation

   Double_t diff = m_par->GetFitValue() - m_ref;
   Double_t bias = (diff > 0 ? m_errp*diff/m_denomP : m_errm*diff/m_denomM);

   return bias;
}

