/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GScan                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Performs 1D and 2D parameter scans                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GScan
#define Gfitter_GScan

#include "Gfitter/GObject.h"

namespace Gfitter {

   class GParameter;
   class GStore;
   class GFitterBase;
   class GResultScan1d;

   class GScan;
   std::ostream& operator << ( std::ostream& os, const GScan& scan );

   class GScan : public GObject {

   public:

      GScan();
      ~GScan();

      void Scan1D( const TString& par, Int_t nbins );
      void Scan1D( GParameter* gpar );

      void PropagateError1D( const TString& par );
      void PropagateError1D( GParameter* gpar );
      
      void Scan2D( const TString& par1, const TString& par2, Int_t nbins1,  Int_t nbins2);
      void Scan2D( GParameter* gpar1, GParameter* gpar2);
    
      GResultScan1d* GetResultScan1d() { return m_result; };
 
   private:

      GResultScan1d* m_result; 

      Bool_t m_scanAll;

   };
}

#endif
