/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GStringList                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/

#include "TObjArray.h"
#include "TObjString.h"
#include "TString.h"
#include "Riostream.h"

#include "Gfitter/GStringList.h"

const TString Gfitter::GStringList::m_replacePattern = "%%";

Gfitter::GStringList::GStringList( const TString& argstr, const TString& separator )
   : m_args       ( *new std::vector<TString>() ),
     m_separator  ( separator ),
     m_hasReplaced( kFALSE ),
     m_logger     ( "GStringList" )
{
   TString s( argstr );
   if (separator ==":") {
      // make sure that no "::" patterns are separated out
      if (s.Contains("::")) {
         if (s.Contains( m_replacePattern )) {
            m_logger << kFATAL << "Protected pattern \"" << m_replacePattern << "\" found in string: \""
                     << s << "\"" << GEndl;
         }
         s.ReplaceAll("::",m_replacePattern);
         m_hasReplaced = kTRUE;
      }
   }

   m_args.clear();
   TObjArray* ar = s.Tokenize( m_separator );
   for (Int_t i=0; i<ar->GetEntries(); i++) {
      // note: removes all blanks in name
      m_args.push_back( ((TObjString*)ar->At(i))->GetString().ReplaceAll(" ","") );
      if (HasReplaced()) m_args.back().ReplaceAll(m_replacePattern,"::"); // reset protected pattern
   }
   delete ar;
}

Gfitter::GStringList::GStringList( std::vector<TString>& args ) 
   : m_args( args ),
     m_separator( ":" ),
     m_hasReplaced( kFALSE ),
     m_logger( "GStringList" )
{}

Gfitter::GStringList::~GStringList()
{}

Bool_t Gfitter::GStringList::Contains( const TString& str )  const 
{
   std::vector<TString>::iterator it;
   for (it = m_args.begin(); it != m_args.end(); it++) if ((*it) == str) return kTRUE;
   return kFALSE;
}

const TString& Gfitter::GStringList::GetArg( Int_t iarg ) const
{
   if (iarg > (Int_t)m_args.size()-1 || iarg < 0) {
      m_logger << kFATAL << "Mismatch in GStringList arg: " << iarg << " > " << (Int_t)m_args.size()-1 << GEndl;
   }
   
   return m_args[iarg];
}

const TString Gfitter::GStringList::GetArgStr() const
{
   TString argstr = "";
   std::vector<TString>::iterator it = m_args.begin();
   for (; it != m_args.end(); it++) {
      if (it != m_args.begin()) argstr += m_separator;
      argstr += *it;
   }   

   return argstr;
}
