/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GTheoryFactory                                                        *
 *                                                                                *
 * Description:                                                                   *
 *      Retrieves theory                                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GTheoryFactory
#define Gfitter_GTheoryFactory

#include <vector>
#include "TROOT.h"
#include "Gfitter/GMsgLogger.h"

namespace Gfitter {

   class GTheoryBase;

   class GTheoryFactory {
    
   public:
      
      // retrieve theory; returns zero if non-existent
      static GTheoryBase* GetTheory( const TString& theoryName );
      static Bool_t InitTheories();
      static Bool_t InitTheory(GTheoryBase* theory);

      // accessors to factory content
      static std::map<const TString, GTheoryBase*>& CreatedTheories()   { return m_allCreatedTheories; }
      static std::vector<GTheoryBase*>&             RequestedTheories() { return m_allRequestedTheories; }

      static void Reset();

   private:

      static void AddTheoryToListOfRequested( GTheoryBase* theory );
      static GTheoryBase* FindTheory( const TString & thName );

      static void CreateMsgLogger();

      // private data
      static std::map<const TString, GTheoryBase*> m_allCreatedTheories;
      static std::vector<GTheoryBase*>             m_allRequestedTheories;
      static std::vector<GTheoryBase*>             m_allAuxiliaryTheories;

      // after the datacard is parsed this flag is set to TRUE
      // with this flag being TRUE only auxiliary theories can be requested
      static Bool_t      m_lockRequested;

      static GMsgLogger* m_logger;
   };
}

#endif
