/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GTimer                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Timer                                                                     *
 *                                                                                *
 *      Adapted from TMVA:Timer. Original authors:                                *
 *                                                                                *
 *      Andreas Hoecker <Andreas.Hocker@cern.ch> - CERN, Switzerland              *
 *      Joerg Stelzer   <Joerg.Stelzer@cern.ch>  - CERN, Switzerland              *
 *      Helge Voss      <Helge.Voss@cern.ch>     - MPI-K Heidelberg, Germany      *
 *      Kai Voss        <Kai.Voss@cern.ch>       - U. of Victoria, Canada         *
 *                                                                                *
 *                                                                                *
 * Copyright (c) 2006                                                             *
 *      CERN, Switzerland                                                         *
 *      MPI-K Heidelberg, Germany                                                 *
 *                                                                                *
 *   http://root.cern.ch/root/htmldoc/src/TMVA__Timer.h.html                      *
 *                                                                                *
 * (http://tmva.sourceforge.net/LICENSE)                                          *
 **********************************************************************************/

#ifndef Gfitter_GTimer
#define Gfitter_GTimer

#include "time.h"
#include "TString.h"
#include "TStopwatch.h"
#include "Gfitter/GMsgLogger.h"

// ensure that clock_t is always defined
#if defined(__SUNPRO_CC) && defined(_XOPEN_SOURCE) && (_XOPEN_SOURCE - 0 == 500 )
#ifndef _CLOCK_T
#define _CLOCK_T
typedef long clock_t; // relative time in a specified resolution
#endif /* ifndef _CLOCK_T */

#endif // SUN and XOPENSOURCE=500

namespace Gfitter {

   class GTimer : public TStopwatch {
  
   public:
  
      GTimer( const char* prefix = "", Bool_t colourfulOutput = kTRUE );
      GTimer( Int_t ncounts, const char* prefix = "", Bool_t colourfulOutput = kTRUE );
      virtual ~GTimer( void );
  
      void Init ( Int_t ncounts );
      void Reset( void );

      // when the "Scientific" flag set, time is returned with subdecimals
      // for algorithm timing measurement
      TString GetElapsedTime  ( Bool_t Scientific = kTRUE  );
      TString GetLeftTime     ( Int_t icounts );
      void    DrawProgressBar ( Int_t );
      void    DrawProgressBar ( TString );
      void    DrawProgressBar ( void );
                          
   private:

      // for colorful output
      const TString& Color( TString ) const;

      Double_t  ElapsedSeconds( void );
      TString   SecToText     ( Double_t, Bool_t ) const;

      Int_t     m_ncounts;               // reference number of "counts" 
      TString   m_prefix;                // prefix for outputs
      Bool_t    m_colourfulOutput;       // flag for use of colors

      static const TString m_gClassName; // used for output
      static const Int_t   fgNbins;      // number of bins in progress bar

      GMsgLogger*          m_logger;     // the output logger
   };

} // namespace

#endif
