/**********************************************************************************
 * Project: G2HDM - 2 Higgs Doublet Model (type -II) fitting package              *
 * Package: G2HDM                                                                 *
 * Class  : BR_BDTauNu                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source: Jernej F. Kamenik, Federico Mescia,                                    *
 *         Phys.Rev.D78:014003,2008, arXiv:0802.3790                              *   
 *                                                                                *
 * see corresponding .h file for author and license information                   *        
 *                                                                                *
 **********************************************************************************/

#include <cmath>
#include <iostream>

#include "TMath.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"

#include "G2HDM/BR_BDTauNu.h"

ClassImp(G2HDM::BR_BDTauNu)

G2HDM::BR_BDTauNu::BR_BDTauNu() 
   : G2HDM::G2HDMBase()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   BookParameter( "mb_MSb",     &m_mb_MSb );
   BookParameter( "epsilon0",   &m_eps0 );   
   BookParameter( "F1",         &m_f1 );
   BookParameter( "F2",         &m_f2 );
   BookParameter( "F3",         &m_f3 );

   BookParameter( "BR_BDenuSc", &m_BR_BDenuSc );
}

Double_t G2HDM::BR_BDTauNu::GetTheoryPrediction() 
{ 
   // Reference: J.F.Kamenik and F.Mescia arXiv:0802.3790
   // Eqs. (2) and (9)

   Double_t tanBeta     = GetTanb();
   Double_t mChargedH   = GetMHch();

   Double_t mtau        = Gfitter::GConstants::mtau();
   Double_t massRatio   = - m_mb_MSb*mtau/(mChargedH*mChargedH);
   Double_t tanBetaTerm = tanBeta*tanBeta/(1+m_eps0*tanBeta);

   Double_t CtauNP      = massRatio*tanBetaTerm;

   Double_t Rtaue       = m_f1*(1.0 + m_f2*CtauNP + m_f3*CtauNP*CtauNP);

   return Rtaue * m_BR_BDenuSc;
}
