/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : R_b                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      B->Xs gamma branching fraction for 2HDM model                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_R_b
#define G2HDM_R_b

#include "G2HDM/G2HDMBase.h"
#include "GEW/QMassRunning.h"





namespace G2HDM {
   
   class Delta_Rb : public G2HDMBase {
      
   public:

      Delta_Rb();
      virtual ~Delta_Rb() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // SM parameters
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_MW;
      Gfitter::GParameterRef p_mt;

      // 2HDM parameters
      
      // reference to QMassRunning
      GEW::QMassRunning& GetQMassRun() const { return (GEW::QMassRunning&)*t_qMassRun; }      
      Gfitter::GTheoryRef    t_qMassRun;

   private:
      
      ClassDef(Delta_Rb,0)
  };
}

#endif
