/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : G2HDMBase                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Decide on base parameters                                                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_G2HDMBase
#define G2HDM_G2HDMBase

#include "TMath.h"
#include "Gfitter/GTheory.h"



namespace G2HDM {
   
   class G2HDMBase : public Gfitter::GTheory {
      
   public:

      G2HDMBase();
      virtual ~G2HDMBase() {}

   protected:

      Double_t GetMHch() const { return (m_MHchScale == Lin ? m_mChargedH : TMath::Power( 10, m_mChargedH )); }
      Double_t GetTanb() const { return (m_tanbScale == Lin ? m_tanBeta   : TMath::Power( 10, m_tanBeta   )); }

   private:

      // lin or log style
      enum Scale { Lin, Log };
      Scale m_MHchScale;
      Scale m_tanbScale;

      // 2HDM parameters
      Gfitter::GParameterRef m_mChargedH;
      Gfitter::GParameterRef m_tanBeta;

      void SetLeptonMass( Double_t m ) { m_mLepton = m; }

   protected:

      Bool_t UseFullSMInput() const { return m_useFullSMInput; }

   private:
      
      Double_t m_mLepton;
      Bool_t   m_useFullSMInput; 

      ClassDef(G2HDMBase,0)
  };
}

#endif
