/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : A0cFB                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of forward-backward asymmetry of c-quarks                      *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/A0cFB.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GTypes.h"

ClassImp(GEW::A0cFB)

GEW::A0cFB::A0cFB() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

// calculation via effective weak mixing angle 
Double_t GEW::A0cFB::GetTheoryPrediction()
{
   Double_t Ratio_e = 1.0 - 4.0*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kElectron);
   Double_t Ratio_c = 1.0 - 4.0*Gfitter::GMath::TwoThird()*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kCharm);

   Double_t a0cfc = 3*( Ratio_e/(1+Ratio_e*Ratio_e)*Ratio_c/(1+Ratio_c*Ratio_c) ); 
   
   return a0cfc;
}
