/**********************************************************************************
 * Project: GEW - SM Paramter fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GHiggsTheoryBase                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      Theory Builder                                                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_GHiggsTheoryBase
#define GEW_GHiggsTheoryBase

#include "Gfitter/GAuxTheory.h"

namespace GEW {

   class GHiggsTheoryBase : public Gfitter::GAuxTheory {

   public:
      
      GHiggsTheoryBase();
      virtual ~GHiggsTheoryBase() {}

      // Get Higgs mass prediction
      virtual Double_t Get_Mh() = 0 ;

   protected:
      
      ClassDef(GHiggsTheoryBase,0)
   };
}

#endif
