/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : HiggsMetastabilityBound                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Bound obtained from vacuum stability requirement:                         *
 *      lambda(mu) > 0 for mu < Lambda_cutoff                                     *
 *                                                                                *
 * Source:                                                                        *
 *      (i) J. Ellis, J. R. Espinosa, G. F. Giudice, A. Hoecker and A. Riotto     *
 *          Phys. Lett. B 679, 369 (2009), [arXiv:0906.0954 [hep-ph]]             *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
**********************************************************************************/

#include "TMath.h"
#include "Riostream.h"
#include "TGraph.h"

#include "Gfitter/GMath.h"

#include "GEW/HiggsMetastabilityBound.h"

using namespace Gfitter;

ClassImp(GEW::HiggsMetastabilityBound)

GEW::HiggsMetastabilityBound::HiggsMetastabilityBound() 
   : HiggsTheoryBound()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "mt",                      &p_mt );   
   BookTheory   ( "GEW::AlphaQCDAtQ/MZ", &t_AlphasMZ ); 
}

void GEW::HiggsMetastabilityBound::Initialise()
{
   m_boundType = kLower;
   HiggsTheoryBound::Initialise();
}

Double_t GEW::HiggsMetastabilityBound::GetCriticalMass()
{
   // units in GeV
   Double_t MHc = 0;

   // eq. (5) from (i)
   MHc = ( 108.9 + 4.0*(p_mt - 173.1)/1.3 - 3.5*(GetAlphasMZ() - 0.1193)/0.0028 );
   
   return MHc;
}
