/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : HiggsStabilityBound                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Bound obtained from vacuum stability requirement:                         *
 *      lambda(mu) > 0 for mu < Lambda_cutoff                                     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
**********************************************************************************/

#ifndef GEW_HiggsStabilityBound
#define GEW_HiggsStabilityBound

#include "GEW/HiggsTheoryBound.h"

class TGraph;

namespace GEW {

   class HiggsStabilityBound : public GEW::HiggsTheoryBound {

   public:
      
      HiggsStabilityBound();
      ~HiggsStabilityBound() {}      

      // Initialise coefficients
      void Initialise();
      
   protected:

      Double_t GetCriticalMass();

      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_criticalHiggsMassError;

      Gfitter::GTheory&      GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef    t_AlphasMZ; 

      const TGraph*          m_sb_ref; // graph for stability bound - reference
      const TGraph*          m_sb_mtp; // graph for stability bound - mtop + 1sigma
      const TGraph*          m_sb_mtm; // graph for stability bound - mtop - 1sigma
      const TGraph*          m_sb_asp; // graph for stability bound - alpha_s + 1sigma
      const TGraph*          m_sb_asm; // graph for stability bound - alpha_s - 1sigma

   private:

      ClassDef(HiggsStabilityBound,0)
   };
}

#endif
