/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : HiggsThermMetastabilityBound                                          *
 *                                                                                *
 * Description:                                                                   *
 *      Bound obtained from vacuum stability requirement:                         *
 *      lambda(mu) > 0 for mu < Lambda_cutoff                                     *
 *                                                                                *
 * Source:                                                                        *
 *      (i) J. Ellis, J. R. Espinosa, G. F. Giudice, A. Hoecker and A. Riotto     *
 *          Phys. Lett. B 679, 369 (2009), [arXiv:0906.0954 [hep-ph]]             *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
**********************************************************************************/

#include "TMath.h"
#include "Riostream.h"
#include "TGraph.h"

#include "Gfitter/GMath.h"

#include "GEW/HiggsThermMetastabilityBound.h"

using namespace Gfitter;

ClassImp(GEW::HiggsThermMetastabilityBound)

GEW::HiggsThermMetastabilityBound::HiggsThermMetastabilityBound() 
   : HiggsTheoryBound()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "mt",                  &p_mt );   

   BookTheory   ( "GEW::AlphaQCDAtQ/MZ", &t_AlphasMZ ); 
}

void GEW::HiggsThermMetastabilityBound::Initialise()
{
   m_boundType = kLower;
   HiggsTheoryBound::Initialise();
}

Double_t GEW::HiggsThermMetastabilityBound::GetCriticalMass()
{
   // units in GeV
   Double_t MHc = 0;

   // Eq (6) from (i)
   MHc = ( 122.0 + 3.0*(p_mt - 173.1)/1.3 - 2.3*(GetAlphasMZ() - 0.1193)/0.0028 );
   
   return MHc;
}
