/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : MW                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of W mass                                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GEW_MW
#define GEW_MW

#include "Gfitter/GTheory.h"




namespace GEW {

   class MH;
   class DAlphaQED;
   class RunningAlphaQCD;

   class MW : public Gfitter::GTheory {

   public:
      
      MW();
      ~MW() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise();

   protected:
    
      // parameters from the Data-Card
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_GF;
      Gfitter::GParameterRef p_DeltaMW_Scale;

      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef    t_DAlphaQED; 
       
      // reference to AlphasRunning
      RunningAlphaQCD& GetAlphasRun() const { return (RunningAlphaQCD&)*t_AlphasRun; }
      Gfitter::GTheoryRef    t_AlphasRun; 

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef    t_AlphasMZ; 

      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // coefficients for the parameterized equation
      Double_t m_MW0;
      Double_t m_c1;
      Double_t m_c2;
      Double_t m_c3;
      Double_t m_c4; 
      Double_t m_c5;
      Double_t m_c6;
      Double_t m_c7;
      Double_t m_c8;
      Double_t m_c9;
      Double_t m_c10;
      Double_t m_c11;

      Bool_t m_logMH;

      ClassDef(MW,0)
   };
}

#endif
