/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0b                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *       Ratio of the bottoms partial Z width to all hadrons                      *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/R0b.h"
#include "GEW/Z0Base.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"

ClassImp(GEW::R0b)

GEW::R0b::R0b() 
  : SMTheoryBuilder()
  , m_forceOldFullTwoLoop( kFALSE )
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   m_forceOldFullTwoLoop = kFALSE ;
   if ( gStore()->ExistVariable( "GEWFlags::ForceFullTwoLoop4R0b" ) ) {
     m_forceOldFullTwoLoop = gStore()->GetVariable( "GEWFlags::ForceFullTwoLoop4R0b" )->GetBoolValue();
     m_logger << kINFO << "Forcing old (Sep 2013) full 2-loop fermionic parametrization for R0b: " << m_forceOldFullTwoLoop << GEndl;
   }

   if ( m_forceOldFullTwoLoop ) {
     BookTheory   ( "GEW::R0bParametrisation",  &t_r0b );
   }

   BookParameter( "DeltaAlphasTheoC05_Scale",  &p_DeltaAlphasTheoC05_Scale );
   BookParameter( "DeltaAlphasTheoCMt4_Scale", &p_DeltaAlphasTheoCMt4_Scale );
   BookTheory   ( "GEW::AlphaQCDAtQ/MZ",  &t_AlphasMZ );
}


Double_t GEW::R0b::GetTheoryPrediction()
{      
   Double_t GaZhad(0.);
   Double_t GaZb(0.);
   Double_t r0b = 0;

   if (m_forceOldFullTwoLoop) {
     r0b = GetR0bPara().GetR0b();
   } else {
     GaZhad = GetZ0Theory().GetGaZhad();
     GaZb = GetZ0Theory().GetGaZbottom();   
     r0b = GaZb/GaZhad;
   }

   // uncertainty due to C05 term in radiator function
   Double_t asmz = GetAlphasMZ();
   Double_t unc_c05 = 0.00279294*TMath::Power(asmz,4.4);
   r0b += unc_c05*(1 - p_DeltaAlphasTheoC05_Scale);

   // uncertainty due to CMt4 term in radiator function
   Double_t unc_mt4 =  -0.10121*GMath::IPow(asmz,4);
   r0b += unc_mt4*(1 - p_DeltaAlphasTheoCMt4_Scale);

   return r0b;
}
