/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0c                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of the charms partial Z width to all hadrons                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/R0lep.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::R0lep)

GEW::R0lep::R0lep() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "DeltaAlphasTheoC05_Scale",  &p_DeltaAlphasTheoC05_Scale );
   BookParameter( "DeltaAlphasTheoCMt4_Scale", &p_DeltaAlphasTheoCMt4_Scale );
   BookTheory   ( "GEW::AlphaQCDAtQ/MZ",  &t_AlphasMZ );   
}

Double_t GEW::R0lep::GetTheoryPrediction()
{
   /// Definition of R0lep assumes massless leptons!
   /// See p62 of http://arxiv.org/pdf/hep-ex/0509008v3.pdf

   Double_t GaZe   = GetZ0Theory().GetGaZelectron();
   Double_t GaZhad = GetZ0Theory().GetGaZhad();
      
   Double_t r0lep = GaZhad/GaZe;

   // theory uncertainty due to missing h.o. terms in radiator function
   // uncertainty due to C05 term in radiator function
   Double_t asmz = GetAlphasMZ();
   Double_t unc_c05 = 16.4262*GMath::IPow(asmz,4);
   r0lep += unc_c05*(1 - p_DeltaAlphasTheoC05_Scale);

   // uncertainty due to CMt4 term in radiator function
   Double_t unc_mt4 =  -2.6677*GMath::IPow(asmz,4);
   r0lep += unc_mt4*(1 - p_DeltaAlphasTheoCMt4_Scale);
    
   return r0lep;
}
