/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Sigma0had                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of hadronic cross-section                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Sigma0had
#define GEW_Sigma0had
 
#include "GEW/SMTheoryBuilder.h"
#include "GEW/Sigma0hadParametrisation.h"


namespace GEW {

   class Sigma0had : public SMTheoryBuilder {
    
   public:

      Sigma0had();
      virtual ~Sigma0had() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      // reference to full two-loop Sigma0had calculation (parametrisation)
      Sigma0hadParametrisation& GetSigma0hadPara() const { return (Sigma0hadParametrisation&)*t_sig0had; }
      Gfitter::GTheoryRef  t_sig0had;

      Gfitter::GParameterRef p_DeltaAlphasTheoC05_Scale;  // for C05 coefficient of Radiator function
      Gfitter::GParameterRef p_DeltaAlphasTheoCMt4_Scale; // for CMt4 coefficient of Radiator function

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef t_AlphasMZ;       
      
      Bool_t m_fullTwoLoop;

      Gfitter::GParameterRef m_MZ;

      ClassDef(Sigma0had,0)
   };
}

#endif
