/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Sigma0hadParametrisation                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of the total hadronic cross section                            *
 *      (parametrised formula for two-loop result)                                *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Sigma0hadParametrisation
#define GEW_Sigma0hadParametrisation
 
#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"
#include "GEW/DAlphaQED.h"
#include "GEW/AlphaQCDAtQ.h"
#include "GEW/MH.h"


namespace GEW {

   class Sigma0hadParametrisation : public Gfitter::GAuxTheory {
    
   public:

      Sigma0hadParametrisation();
      virtual ~Sigma0hadParametrisation() {}

      // return GammaZ_tot value
      Double_t GetSigma0had();

      // initialise coefficients
      void Initialise();

      // update stored value
      void Update(Double_t val);
 
   protected:

     // parameters from the Data-Card
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_DeltaSigma0had_Scale;
  
      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef t_DAlphaQED; 
       
      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef t_AlphasMZ; 

      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // stored value of sigma0had
      Double_t m_sig0had;

      // coefficients for the parameterized equation
      Double_t m_X0;
      Double_t m_c1;
      Double_t m_c2;
      Double_t m_c3;
      Double_t m_c4; 
      Double_t m_c5;
      Double_t m_c6;
      Double_t m_c7;
      Double_t m_c8;      
      Double_t m_c9;
      Double_t m_c10;
      Double_t m_c11;
      Double_t m_c12;
      Double_t m_c13;
      Double_t m_c14;
      Double_t m_c15;

      Bool_t m_logMH;

      ClassDef(Sigma0hadParametrisation,0)
   };
}

#endif
