/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Epsilon1                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      epsilon1                                                                  *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "GOblique/Epsilon1.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GTypes.h"

#include "GOblique/EpsilonParametrisation.h"

ClassImp(GOblique::Epsilon1)

GOblique::Epsilon1::Epsilon1()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory   ( "GOblique::EpsilonParametrisation", &t_Para );  
}

Double_t GOblique::Epsilon1::GetTheoryPrediction()
{
   return GetPara().GetEpsilon1();
}
