/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Epsilon2                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      epsilon2                                                                  *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GOblique/Epsilon2.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GTypes.h"

#include "GOblique/EpsilonParametrisation.h"

ClassImp(GOblique::Epsilon2)

GOblique::Epsilon2::Epsilon2()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory   ( "GOblique::EpsilonParametrisation", &t_Para );  
}

Double_t GOblique::Epsilon2::GetTheoryPrediction()
{
   return GetPara().GetEpsilon2();
}
