/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : U                                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      U Parameter                                                               *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "GOblique/U.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GTypes.h"

#include "GOblique/EpsilonParametrisation.h"

ClassImp(GOblique::U)

GOblique::U::U()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory   ( "GOblique::EpsilonParametrisation", &t_Para );  
}

Double_t GOblique::U::GetTheoryPrediction()
{
   return GetPara().GetU();
}
