/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : InertDoubletModel                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections from the inert doublet model                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_InertDoubletModel
#define GSTU_InertDoubletModel

#include "GSTU/TheoryBase.h"
#include "GEW/MW.h"






namespace GSTU {

   class InertDoubletModel : public TheoryBase {

   public:
      
      InertDoubletModel();
      virtual ~InertDoubletModel() {}

      Double_t GetS();
      Double_t GetT();
      Double_t GetU(){ return 0; };
      // are set to zero in this model
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };

      // different variants to compute S
      Double_t GetS_Numerical();
      Double_t GetS_Analytical();

      // additional corrections to Z->bb couplings 
      Double_t Get_deltagLb() {return 0; };
      Double_t Get_deltagRb(){ return 0; };

      // Initialise coefficients
      void Initialise();

   protected:
      
      // helper functions
      static Double_t Sfunc( Double_t *x, Double_t *par );
      Double_t F( Double_t m1, Double_t m2 );

      // Choice of parameters
      Bool_t m_UseDeltaMch;

      // Inert Doublet Model
      Gfitter::GParameterRef p_MHcharge;
      Gfitter::GParameterRef p_ML;
      Gfitter::GParameterRef p_DeltaM;
      Gfitter::GParameterRef p_MA0;
      Gfitter::GParameterRef p_DeltaMch;
      
      ClassDef(InertDoubletModel,0)
   };
}

#endif
