/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LED_Delta_eHad                                                        *
 *                                                                                *
 * Description:                                                                   *
 *      Estimate of the ratio betwenn cut-off and MD in the large extra           *
 *      dimension scenario                                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_LED_Delta_eHad
#define GSTU_LED_Delta_eHad

#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "GEW/DAlphaQED.h"

namespace GSTU {

   class LED_Delta_eHad : public Gfitter::GTheory {

   public:
      
      LED_Delta_eHad();
      ~LED_Delta_eHad() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      Int_t m_ndim;
      bool m_logScale;
      
      Gfitter::GParameterRef p_MZ; 
      Gfitter::GParameterRef p_GF; 

      Gfitter::GParameterRef p_MD; 
      Gfitter::GParameterRef p_logMD; 

      Gfitter::GParameterRef p_LambdaMD; 
      Gfitter::GParameterRef p_logLambdaMD; 
      
      // reference to DAlphaQED
      GEW::DAlphaQED& GetDAlphaQED() const { return (GEW::DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef t_DAlphaQED; 

 

      ClassDef(LED_Delta_eHad,0)
   };
}

#endif
