/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LED_EWConstraint                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      Estimate of the ratio betwenn cut-off and MD                              *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_LED_EWConstraint
#define GSTU_LED_EWConstraint

#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "GSTU/Delta_eHad.h"
#include "GSTU/LED_Delta_eHad.h"

namespace GSTU {

   class LED_EWConstraint : public Gfitter::GTheory {

   public:
      
      LED_EWConstraint();
      ~LED_EWConstraint() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      // reference to theories
      Gfitter::GTheory& GetLEDPred() const { return (Gfitter::GTheory&)*t_led; }      
      Gfitter::GTheoryRef  t_led; 

      Gfitter::GTheory& GetSTUPred() const { return (Gfitter::GTheory&)*t_stu; }      
      Gfitter::GTheoryRef  t_stu; 
      
      ClassDef(LED_EWConstraint,0)
   };
}

#endif
