/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : MW                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - C. P. Burgess, Pramana 45 , S47 (1995), [arXiv:hep-ph/9411257]          *
 *        (see also references)                                                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"

#include "GSTU/MW.h"

ClassImp(GSTU::MW)

GSTU::MW::MW(): SMPredictions(){}

Double_t GSTU::MW::GetTheoryPrediction()
{
   Update();

   // see table 1 from hep-ph/9411257
   Double_t MW2 = TMath::Power( GetSM_MW().GetTheoryPrediction(), 2 )*
      (1. - 0.00723*GetS() + 0.0111*GetT() + 0.00849*GetU() ); 
   
   return TMath::Sqrt(MW2);
}
