/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : NanPenalty                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Penalty check for NaN                                                     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GSTU_NanPenalty
#define GSTU_NanPenalty

#include "Gfitter/GTheory.h"

namespace Gfitter {
  class GParameterRef;
  class GTheoryRef;
  class GReference;
}

namespace GSTU 
{
  class NanPenalty : public Gfitter::GTheory {
  
   public:
  
    NanPenalty();
    ~NanPenalty() {}
    
    /// Theory Prediction
    Double_t GetTheoryPrediction();
    
    /// Initialise coefficients
    void Initialise() ;
    
   protected:
  
    /// update of flags in case of parameter change
    void UpdateLocalFlags( Gfitter::GReference& ref );
    
    /// update parameters
    void Update();
    
    Bool_t m_isUpToDate_Update;
    Double_t m_value;

   private:

    ClassDef(NanPenalty,0)
  };
}

#endif
