/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : R0b                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of ratio between bottom and hadronic Z width                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_R0b
#define GSTU_R0b

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class R0b : public SMPredictions {

   public:
      
      R0b();
      ~R0b() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(R0b,0)
   };
}

#endif
