/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : S_Theory                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Theory Prediction of S parameter                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_S_Theory
#define GSTU_S_Theory

#include "GSTU/TheoryHandler.h"

namespace GSTU {

   class S_Theory : public TheoryHandler {

   public:
      
      S_Theory();
      ~S_Theory() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:

      ClassDef(S_Theory,0)
    };
}

#endif
