/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Sigma0had                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of hadronic pole cross-section                                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_Sigma0had
#define GSTU_Sigma0had

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class Sigma0had : public SMPredictions {

   public:
      
      Sigma0had();
      ~Sigma0had() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(Sigma0had,0)
   };
}

#endif
