/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : UED
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections from the UED model                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GSTU_UED
#define GSTU_UED

#include "GSTU/TheoryBase.h"
#include "GEW/MW.h"






namespace GSTU {

   class UED : public TheoryBase {

   public:
      
      UED();
      virtual ~UED() {}

      Double_t GetS();
      Double_t GetT();
      Double_t GetU();
      // are set to zero in this model
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };

      // additional corrections to Z->bb couplings 
      Double_t Get_deltagLb() {return 0; };
      Double_t Get_deltagRb(){ return 0; };

      // Initialise coefficients
      void Initialise();

   protected:
      
      // parameters
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_MH;

      // Radius of UED
      Gfitter::GParameterRef p_MKK;

      // reference to MW
      GEW::MW& GetMW() const { return (GEW::MW&)*t_MW; }      
      Gfitter::GTheoryRef t_MW; 

      ClassDef(UED,0)
   };
}

#endif
