#! /bin/sh

mkdir -p include; 
cd include;
if [ ! -h Gfitter ]; then ln -s ../src Gfitter; fi;
if [ ! -h GEW ]; then ln -s ../gew GEW; fi;
if [ ! -h GSM ]; then ln -s ../gsm GSM; fi;
if [ ! -h GTest ]; then ln -s ../gtest GTest; fi;
if [ ! -h GSUSY ]; then ln -s ../gsusy GSUSY; fi;
if [ ! -h G2HDM ]; then ln -s ../g2hdm G2HDM; fi;
if [ ! -h GOblique ]; then ln -s ../goblique GOblique; fi;
if [ ! -h GSTU ]; then ln -s ../gstu GSTU; fi;

cd ..

# check Root environment setup
if [ ! $ROOTSYS ]; then
  echo "Warning: Root environment (ROOTSYS) not yet defined. Please do so! "
fi

if [ ! $LD_LIBRARY_PATH ]; then
  echo "Warning: so far you haven't setup your ROOT enviroment properly (no LD_LIBRARY_PATH): Gfitter will not work"
fi

export LD_LIBRARY_PATH=$HOME/Gfitter/lib:$PWD/../lib:$PWD/lib:${LD_LIBRARY_PATH}
export PATH=${PWD}/scripts:$ROOTSYS/bin:${PATH}

# Gfitter dir
export GFITTERDIR=${PWD}

# PYTHONPATH contains all directories that are used for 'import bla' commands
export PYTHONPATH=${PYTHONPATH}:${GFITTERDIR}/scripts

