/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GDataBase                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Base class for Data                                                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GDataBase
#define Gfitter_GDataBase

#include "Gfitter/GObject.h"

namespace Gfitter {  

   class GDataBase : public GObject {

   public:

      GDataBase();
      GDataBase( const GDataBase& );
      virtual ~GDataBase();

      // required methods
      virtual Double_t GetValue() const = 0;
      virtual Double_t GetGaussRnd( Double_t mean ) const = 0;
      virtual Double_t GetRndValue( Double_t mean ) = 0;
      virtual Bool_t   SetValue   ( Double_t v ) = 0;
      virtual Double_t GetErrGaussp() const = 0;
      virtual Double_t GetErrGaussm() const = 0;

      virtual Double_t GetErrTotp()   const = 0;
      virtual Double_t GetErrTotm()   const = 0;
      virtual Double_t GetErrTotSym() const = 0;

      // provided by base class
      virtual Double_t GetFitValue() const { return m_fitValue; }
      virtual Bool_t   SetFitValue( Double_t v );

   protected:

      Double_t m_fitValue;  // can be varied by fit
      
      ClassDef(GDataBase,1)         
   };

   ostream& operator << ( ostream& os, const Gfitter::GDataBase& );

}

//
// -------------------- i n l i n e   f u n c t i o n s ---------------------------------
//

inline Bool_t Gfitter::GDataBase::SetFitValue( Double_t v ) 
{ 
   Bool_t signifChange = false;
   if (m_fitValue != 0){
     if (TMath::Abs((m_fitValue-v)/m_fitValue)>1E-10) signifChange = true;
   }
   m_fitValue = v;
  
   return signifChange;
}

#endif
