/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GFunctionOfFreeParameter                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Create 1D and 2D parameter functions in dependency of one free parameter  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GFunctionOfFreeParameter
#define Gfitter_GFunctionOfFreeParameter

#include "Gfitter/GObject.h"

namespace Gfitter {

   class GParameter;
   class GStore;
   class GFitterBase;
   class GResultScan1d;

   class GFunctionOfFreeParameter;
   std::ostream& operator << ( std::ostream& os, const GFunctionOfFreeParameter& scan );

   class GFunctionOfFreeParameter : public GObject {

   public:

      GFunctionOfFreeParameter();
      ~GFunctionOfFreeParameter();

      void FctOfFreePara( const TString& par, Int_t nbins );
      void FctOfFreePara( GParameter* gpar, Int_t nbins );

   private:

   };
}

#endif
