/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GGeneticFitter                                                        *
 *                                                                                *
 * Description:                                                                   *
 *      Fit wrapper for TMVA Genetic Algorithm                                    *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GGeneticFitter
#define Gfitter_GGeneticFitter

#include "Gfitter/GFitterBase.h"
#include "TMVA/IFitterTarget.h"
#include "TMVA/Interval.h"
#include "TMVA/GeneticAlgorithm.h"

namespace Gfitter {

   class GStore;

   class GGeneticFitter : public GFitterBase, TMVA::IFitterTarget {
      
   public:
      
      GGeneticFitter(); // default constructor
      virtual ~GGeneticFitter();

      // initialise fitter
      void     Initialise();

      // perform fit, and return minimum chi-squared
      Double_t ExecuteFit();
      Double_t GetCurrentChi2();

		void UpdateResults();

      // scan 2D contour
      void DrawContour( GParameter* gpar1, GParameter* gpar2, 
                        Int_t npoints, Double_t dchi2, Double_t* npx, Double_t* npy );

      // interface to FCN in GFitterBase
      Double_t EstimatorFunction( std::vector<Double_t> & factors ); 

      // read the configuration parameters from GStore
      void ReadGAConfiguration(); 

      // print the configuration parameters
      void PrintGAConfiguration(); 

   protected:

   private:

      static GGeneticFitter*  GetThisPtr();
      static GGeneticFitter*  m_This;
      
      TMVA::GeneticAlgorithm* m_ga;
      
      // Configuration parameters
      Int_t                   m_populationSize;
      Int_t                   m_convsteps;
      Double_t                m_convcrit;
      Int_t                   m_scsteps;
      Int_t                   m_scrate;
      Double_t                m_scfactor;

   };   

}

#endif
