/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GGraph2PDF                                                            *
 *                                                                                *
 * Description:                                                                   *
 *                                                                                * 
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GGraph2PDF
#define Gfitter_GGraph2PDF

#include "GObject.h"

#include "TGraph.h"
#include "TF1.h"

namespace Gfitter {
   
   class GGraph2PDF : public GObject {
      
   public:
      
      GGraph2PDF(TGraph *chi2, Double_t offset );
      virtual ~GGraph2PDF( void );
      
      // returns y Value at xend
      Double_t Evaluate( Double_t *x, Double_t *par);
      
   private:
      
      Double_t m_offset;
      TGraph  *m_graph;

   };

}

#endif

