/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GMultiNestFitter                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Minuit (TFitter) fitter                                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GMultiNestFitter
#define Gfitter_GMultiNestFitter

#include "Gfitter/GFitterBase.h"
#include "multinest.h"
#include "Gfitter/GTimer.h"

//class TMinuit;

namespace Gfitter {

   class GStore;

   class GMultiNestFitter : public GFitterBase {
      
   public:
      
      GMultiNestFitter(); // default constructor
      virtual ~GMultiNestFitter();

      // initialise fitter
      void     Initialise();

      // perform fit, and return minimum chi-squared
      Double_t ExecuteFit();
      Double_t GetCurrentChi2();
      void SetCurrentChi2(Double_t chi2){ m_chi2=chi2;}

      void UpdateResults();

      // scan 2D contour
      void DrawContour(GParameter* gpar1, GParameter* gpar2, 
                       Int_t npoints, Double_t dchi2, Double_t* npx, Double_t* npy);

      // receive the list of sample points
      std::vector<double> GetPosterior(){return m_postdist;};
      std::vector<double> GetLivePoints(){return m_LivePts;};
      int GetNPar(){return m_nPar;};
      int GetNLive(){return m_nlive;};
      int GetNSamples(){return m_nSamples;};

   protected:

      Bool_t         m_isFirstInit;

      // MultiNest interface to GFitterBase::FCN(...)
      static void LogLike(double *Cube, int &ndim, int &npars, double &lnew, void *context);

      //MultiNest standard output routine
      static void dumper(int &nSamples, int &nlive, int &nPar, double **physLive, double **posterior, double **paramConstr, double &maxLogLike, double &logZ, double &INSlogZ, double &logZerr, void *context);


   private:

      static GMultiNestFitter* GetThisPtr();
      static GMultiNestFitter* m_This;       

      //current chi2 value
      Double_t m_chi2;

      int m_nlive;				// number of live points
      double m_efr;				// set the required efficiency  
      double m_tol;				// tol, defines the stopping criteria
      bool m_ceff;                              // run in constant efficiency mode
      int m_maxiter; 			        // max no. of iterations, a non-positive value means infinity. MultiNest will terminate if either it 
                                                // has done max no. of iterations or convergence criterion (defined through tol) has been satisfied
      bool m_fb;                                // need feedback on standard output?
      bool m_resume;                    	// resume from a previous job?
      bool m_outfile;                   	// write output files?
      TString m_outfilename;

      static double ScaleUniformPrior(double r, double x1, double x2);
      static double ScaleGaussPrior(double r, double mu, double sigmaplus, double sigmaminus);

      GTimer* m_timer;
      int m_iter;
      int m_updInt;

      // fit output 
      std::vector<double> m_postdist;
      std::vector<double> m_LivePts;
      int m_nSamples;
      int m_nPar;

      ClassDef(GMultiNestFitter,0)

   };   
}

#endif
