/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GObject                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Gfitter base class                                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GObject
#define Gfitter_GObject

#include "Rtypes.h"
#include "TObject.h"

#include "Gfitter/GMsgLogger.h"

// for debugging
#define HERE(a) std::cout << "*** here: " << a << std::endl

class TRandom;
class TString;

namespace Gfitter {   

   class GObject : public TObject {

   public:

      GObject();
      GObject( const GObject& );
      virtual ~GObject();

      const TString   GetClassName() const { return m_className; }
      const TString   GetPrintName() const;
      void            SetClassName( const TString& name ) { m_className = name; }

      // static functions for random generation
      static TRandom* GetRandom() { return m_random; }
      static void     SetRandomSeed( Int_t seed );

   protected:

      virtual void    InitClassName( const TString& className ); // called by all derived classes
      
      //
      // note, do not remove the "!" in "//!": it indicates that these fields are not persistified
      //

      static TRandom*    m_random;      //! random generator 
      static UInt_t      m_randomSeed;  //! random seed
      
      TString            m_className;   // name of the derived class

      mutable GMsgLogger m_logger;      //! the message logger

      ClassDef(GObject,1)         
   };
}

#endif
