/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GReference                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Parameter container                                                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GReference
#define Gfitter_GReference

#include "TObject.h"
#include "TString.h"

namespace Gfitter {
   
   class GTheoryBase;

   class GReference : public TObject {

   public:
    
      /**@brief constructor
       *
       * @param th the theory which owns this reference
       */
      GReference() :
         m_hasChanged(kTRUE), m_requestingTheory(0) {}

      /**@brief destructor*/
      virtual ~GReference() {}

      void SetOwner( GTheoryBase* th ) { m_requestingTheory = th; } 

      const TString& GetTheoryName();
      
      void   SetChanged();
      void   SetUsed()          { m_hasChanged = kFALSE; }
      Bool_t HasChanged() const { return m_hasChanged; }

   private:

      Bool_t        m_hasChanged;
      GTheoryBase * m_requestingTheory;
   };
}

#endif
