/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GResultEval                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Result of a Evaluate action                                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GResultEval
#define Gfitter_GResultEval

#include "TROOT.h"

#include "TMatrixD.h"

#include "Gfitter/GResultBase.h"

namespace Gfitter {

   class GResultEval : public GResultBase {

   public:

      GResultEval();
      GResultEval( Double_t value,       Double_t chi2min,
                   Double_t errGaussp,   Double_t errGaussm,
                   Double_t errGaussSym, Double_t globalCorr,
                   TMatrixD*& corrMat,   const TString fitDuration );
      ~GResultEval();

      // accessors
      Double_t        GetValue()       const { return m_value; }
      Double_t        GetChi2Min()     const { return m_chi2min; }
      Double_t        GetErrGaussSym ( UInt_t nsigma ) const;
      Double_t        GetErrGaussAsym( Int_t  nsigma ) const;
      Double_t        GetGlobCorr()    const { return m_globalCorr; }
      const TMatrixD* GetCorrMat()     const { return m_corrMat; }
      const TMatrixD* GetCovMat()      const { return m_covMat; }
      const TString   GetFitDuration() const { return m_fitDuration; }

   private:

      Double_t        m_value;
      Double_t        m_chi2min;
      Double_t        m_errGaussSym;
      Double_t        m_errGaussp;
      Double_t        m_errGaussm;
      Double_t        m_globalCorr;
      TMatrixD*       m_covMat;
      TMatrixD*       m_corrMat;
      TString         m_fitDuration;

      ClassDef(GResultEval,1)         
   };
}

#endif
